#!/bin/sh
# Name: Snake
# Author: kindlemodshelfguy
# DontUseFBInk
# Install/register & launch Snake as a Mesquite WAF via Illusion

SOURCE_DIR="/mnt/us/documents/snake"
TARGET_DIR="/var/local/mesquite/snake"
DB="/var/local/appreg.db"
APP_ID="com.you.kindlesnake"

# Copy app into Mesquite location
if [ -d "$SOURCE_DIR" ]; then
  rm -rf "$TARGET_DIR"
  cp -r "$SOURCE_DIR" "$TARGET_DIR"
else
  echo "Source not found: $SOURCE_DIR" >/dev/null
  exit 1
fi

# Register in appreg.db (best-effort)
if [ -f "$DB" ]; then
  sqlite3 "$DB" <<EOF
INSERT OR IGNORE INTO interfaces(interface) VALUES('application');
INSERT OR IGNORE INTO handlerIds(handlerId) VALUES('$APP_ID');
INSERT OR REPLACE INTO properties(handlerId,name,value) VALUES('$APP_ID','lipcId','$APP_ID');
INSERT OR REPLACE INTO properties(handlerId,name,value) VALUES('$APP_ID','command','/usr/bin/mesquite -l $APP_ID -c file://$TARGET_DIR/');
INSERT OR REPLACE INTO properties(handlerId,name,value) VALUES('$APP_ID','supportedOrientation','U');
EOF
fi

# Launch
sleep 2
nohup lipc-set-prop com.lab126.appmgrd start app://$APP_ID >/dev/null 2>&1 &
