var SIZE = 4;
var grid = [];
var score = 0;

function $(id){ return document.getElementById(id); }

// --- INIT ---
function init() {
  grid = [];
  for (var r=0;r<SIZE;r++){
    grid[r] = [];
    for (var c=0;c<SIZE;c++){ grid[r][c]=0; }
  }
  score = 0;
  addTile(); addTile();
  draw();
  setMessage("");
  resizeLayout();
}

// --- BUTTON PRESS WRAPPER ---
function press(btn, action){
  if(btn && btn.blur){ btn.blur(); } // fix highlight glitch
  if(action==="new") newGame();
  else if(action==="reload") reloadApp();
  else move(action);
}

// --- LAYOUT DYNAMICS ---
function resizeLayout(){
  var screenW = window.innerWidth;
  var screenH = window.innerHeight;

  var gridSize = Math.min(screenW*0.9, screenH*0.55);
  var cellSize = Math.floor(gridSize / SIZE);

  // --- Grid cells ---
  var cells = $("grid").getElementsByTagName("td");
  for(var i=0;i<cells.length;i++){
    cells[i].style.width = cellSize + "px";
    cells[i].style.height = cellSize + "px";
    cells[i].style.fontSize = Math.floor(cellSize/3) + "px";
  }

  // --- Title & Score ---
  $("title").style.fontSize = Math.floor(gridSize/10) + "px";
  $("scoreBox").style.fontSize = Math.floor(gridSize/14) + "px";

  // --- D-Pad controls ---
  var controls = $("controls");
  controls.style.width = gridSize + "px";
  var btns = controls.getElementsByTagName("button");
  for(var j=0;j<btns.length;j++){
    btns[j].style.width = Math.floor(gridSize/4) + "px";
    btns[j].style.height = Math.floor(cellSize*0.9) + "px";
    btns[j].style.fontSize = Math.floor(cellSize/2.5) + "px";
  }

  // --- Actions (New Game + Reload) ---
  var actBtns = $("actions").getElementsByTagName("button");
  for(var k=0;k<actBtns.length;k++){
    actBtns[k].style.width = Math.floor(gridSize/3.2) + "px";
    actBtns[k].style.height = Math.floor(cellSize*0.9) + "px";
    actBtns[k].style.fontSize = Math.floor(cellSize/3.5) + "px";
  }

  // --- Message ---
  $("message").style.fontSize = Math.floor(gridSize/14) + "px";
}

// --- GAME LOGIC ---
function addTile(){
  var empty=[];
  for (var r=0;r<SIZE;r++){
    for (var c=0;c<SIZE;c++){
      if(grid[r][c]===0) empty.push({r:r,c:c});
    }
  }
  if(empty.length){
    var spot=empty[Math.floor(Math.random()*empty.length)];
    grid[spot.r][spot.c]=Math.random()<0.9?2:4;
  }
}

function draw(){
  var table=$("grid");
  table.innerHTML="";
  for(var r=0;r<SIZE;r++){
    var row=document.createElement("tr");
    for(var c=0;c<SIZE;c++){
      var cell=document.createElement("td");
      cell.textContent=grid[r][c]||"";
      row.appendChild(cell);
    }
    table.appendChild(row);
  }
  $("score").textContent=score;
  resizeLayout();
}

function slide(row){
  var arr=row.filter(function(v){return v;});
  for(var i=0;i<arr.length-1;i++){
    if(arr[i]===arr[i+1]){
      arr[i]*=2;
      score+=arr[i];
      arr[i+1]=0;
    }
  }
  arr=arr.filter(function(v){return v;});
  while(arr.length<SIZE) arr.push(0);
  return arr;
}

function move(dir){
  var old=JSON.stringify(grid);
  if(dir==="left"){
    for(var r=0;r<SIZE;r++){ grid[r]=slide(grid[r]); }
  } else if(dir==="right"){
    for(var r=0;r<SIZE;r++){
      grid[r].reverse();
      grid[r]=slide(grid[r]);
      grid[r].reverse();
    }
  } else if(dir==="up"){
    for(var c=0;c<SIZE;c++){
      var col=[];for(var r=0;r<SIZE;r++){ col.push(grid[r][c]); }
      col=slide(col);
      for(var r2=0;r2<SIZE;r2++){ grid[r2][c]=col[r2]; }
    }
  } else if(dir==="down"){
    for(var c=0;c<SIZE;c++){
      var col=[];for(var r=0;r<SIZE;r++){ col.push(grid[r][c]); }
      col.reverse();
      col=slide(col);
      col.reverse();
      for(var r2=0;r2<SIZE;r2++){ grid[r2][c]=col[r2]; }
    }
  }
  if(JSON.stringify(grid)!==old){
    addTile();
    draw();
    checkGame();
  }
}

function checkGame(){
  for(var r=0;r<SIZE;r++){
    for(var c=0;c<SIZE;c++){
      if(grid[r][c]===2048){ setMessage("You win!"); return; }
    }
  }
  for(var r2=0;r2<SIZE;r2++){
    for(var c2=0;c2<SIZE;c2++){
      if(grid[r2][c2]===0) return;
      if(c2+1<SIZE && grid[r2][c2]===grid[r2][c2+1]) return;
      if(r2+1<SIZE && grid[r2][c2]===grid[r2+1][c2]) return;
    }
  }
  setMessage("Game Over");
}

function newGame(){ init(); }
function setMessage(msg){ $("message").textContent=msg; }
function reloadApp(){ try{ window.location.reload(); }catch(e){} }

window.addEventListener("resize",resizeLayout);
document.addEventListener("DOMContentLoaded",init);
